package org.nakedobjects.nos.client.dnd;

import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.noa.reflect.NakedObjectAction;
import org.nakedobjects.nos.client.dnd.drawing.Location;


public interface UserAction {
    public static final NakedObjectAction.Type USER = NakedObjectAction.USER;
    public static final NakedObjectAction.Type DEBUG = NakedObjectAction.DEBUG;
    public static final NakedObjectAction.Type EXPLORATION = NakedObjectAction.EXPLORATION;

    /**
     * Returns the type of action: user, exploration, debug, or a set.
     */
    NakedObjectAction.Type getType();

    /**
     * Indicate that this action is disabled
     */
    Consent disabled(View view);

    /**
     * Invoke this action.
     */
    void execute(Workspace workspace, View view, Location at);

    /**
     * Returns the description of the action.
     */
    String getDescription(View view);

    /**
     * Returns the help text for the action.
     */
    String getHelp(View view);

    /**
     * Returns the name of the action as the user will refer to it.
     */
    String getName(View view);
}
// Copyright (c) Naked Objects Group Ltd.
