package org.nakedobjects.nos.client.dnd;

import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.nos.client.dnd.drawing.Location;


public interface Workspace extends View {

    View addIconFor(Naked naked, Location at);

    View addOpenViewFor(Naked object, Location at);

    // TODO this can probably be replace with two methods: createIcon and createView
    View createSubviewFor(Naked object, boolean asIcon);

    /**
     * Lower the specified view so it is below all the other views.
     */
    void lower(View view);

    /**
     * Raise the specified view so it is above all the other views.
     */
    void raise(View view);

    /**
     * Close all views for the specified object.
     */
    void removeViewsFor(NakedObject object);

    void removeObject(NakedObject object);
}
// Copyright (c) Naked Objects Group Ltd.
