package org.nakedobjects.nos.client.dnd.action;

import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.noa.reflect.NakedObjectAction;
import org.nakedobjects.noa.reflect.NakedObjectAction.Type;
import org.nakedobjects.nof.core.reflect.Allow;
import org.nakedobjects.nos.client.dnd.ButtonAction;
import org.nakedobjects.nos.client.dnd.View;


public abstract class AbstractButtonAction implements ButtonAction {
    private final String name;
    private final boolean defaultButton;

    public AbstractButtonAction(final String name) {
        this(name, false);
    }

    public AbstractButtonAction(final String name, final boolean defaultButton) {
        this.name = name;
        this.defaultButton = defaultButton;
    }

    public Consent disabled(final View view) {
        return Allow.DEFAULT;
    }

    public String getDescription(final View view) {
        return "";
    }

    public String getHelp(final View view) {
        return "No help available for button";
    }

    public String getName(final View view) {
        return name;
    }

    public Type getType() {
        return NakedObjectAction.USER;
    }

    public boolean isDefault() {
        return defaultButton;
    }
}
// Copyright (c) Naked Objects Group Ltd.
