package org.nakedobjects.nos.client.dnd.action;

import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.noa.reflect.NakedObjectAction;
import org.nakedobjects.noa.reflect.NakedObjectAction.Type;
import org.nakedobjects.nof.core.reflect.Allow;
import org.nakedobjects.nof.core.util.ToString;
import org.nakedobjects.nos.client.dnd.UserAction;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.drawing.Location;


/**
 * Each option that a user is shown in an objects popup menu a MenuOption. A MenuOption details: the name of
 * an option (in the users language);
 * <ul>
 * the type of object that might result when requesting this option
 * </ul>; a way to determine whether a user can select this option on the current object.
 */
public abstract class AbstractUserAction implements UserAction {
    private String description;
    private String name;
    private Type type;

    public AbstractUserAction(final String name) {
        this(name, NakedObjectAction.USER);
    }

    public AbstractUserAction(final String name, final Type type) {
        this.name = name;
        this.type = type;
    }

    public Consent disabled(final View view) {
        return Allow.DEFAULT;
    }

    public abstract void execute(final Workspace workspace, final View view, final Location at);

    public String getDescription(final View view) {
        return description;
    }

    public String getHelp(final View view) {
        return "No help available for user action";
    }

    /**
     * Returns the stored name of the menu option.
     */
    public String getName(final View view) {
        return name;
    }

    public Type getType() {
        return type;
    }

    public void setName(final String name) {
        this.name = name;
    }

    public String toString() {
        ToString str = new ToString(this); 
        str.append("name", name);
        str.append("type", type);
        return str.toString();
    }
}
// Copyright (c) Naked Objects Group Ltd.
