package org.nakedobjects.nos.client.dnd.action;

import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.nof.core.util.ToString;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.drawing.Location;


public class CloseAllViewsForObjectOption extends AbstractUserAction {
    public CloseAllViewsForObjectOption() {
        super("Close all views for this object");
    }

    public void execute(final Workspace workspace, final View view, final Location at) {
        workspace.removeViewsFor((NakedObject) view.getContent().getNaked());
    }

    public String getDescription(final View view) {
        String title = view.getContent().title();
        return "Close all views for '" + title + "'";
    }

    public String toString() {
        return new ToString(this).toString();
    }
}
// Copyright (c) Naked Objects Group Ltd.
