package org.nakedobjects.nos.client.dnd.action;

import org.nakedobjects.nof.core.util.ToString;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.drawing.Location;


public class CloseAllViewsOption extends AbstractUserAction {
    public CloseAllViewsOption() {
        super("Close all others");
    }

    public void execute(final Workspace workspace, final View view, final Location at) {
        View views[] = view.getWorkspace().getSubviews();

        for (int i = 0; i < views.length; i++) {
            View otherView = views[i];
            if (otherView.getSpecification().isOpen() && otherView != view) {
                otherView.dispose();
            }
        }
    }

    public String getDescription(final View view) {
        return "Close all view except " + view.getSpecification().getName().toLowerCase();
    }

    public String toString() {
        return new ToString(this).toString();
    }
}
// Copyright (c) Naked Objects Group Ltd.
