package org.nakedobjects.nos.client.dnd.action;

import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.persist.NakedObjectPersistor;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.reflect.Allow;
import org.nakedobjects.nof.core.reflect.Veto;
import org.nakedobjects.nos.client.dnd.ObjectContent;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.drawing.Location;


/**
 * Destroy this object
 */
public class DisposeObjectOption extends AbstractUserAction {
    public DisposeObjectOption() {
        super("Dispose Object", EXPLORATION);
    }

    public Consent disabled(final View view) {
        NakedObject adapter = (NakedObject) view.getContent().getNaked();
        if (adapter.getResolveState().isDestroyed()) {
            return new Veto("Can't do anything with a destroyed object");
        }
        if (isObjectInRootView(view)) {
            return Allow.DEFAULT;
        } else {
            return new Veto("Can't dispose an object from within another view.");
        }
    }

    private boolean isObjectInRootView(final View view) {
        View rootView = rootView(view);
        return view.getContent() == rootView.getContent();
    }

    private View rootView(final View view) {
        View parent = view.getParent();
        if (view.getWorkspace() == parent) {
            return view;
        } else {
            return rootView(parent);
        }
    }

    public void execute(final Workspace workspace, final View view, final Location at) {

        NakedObject object = ((ObjectContent) view.getContent()).getObject();

        NakedObjectPersistor persistor = NakedObjectsContext.getObjectPersistor();
        persistor.startTransaction();
        persistor.destroyObject(object);
        persistor.endTransaction();

        NakedObjectsContext.getUpdateNotifer().addDisposedObject(object);
        view.getViewManager().disposeUnneededViews();
        view.getFeedbackManager().showMessagesAndWarnings();
    }
}
// Copyright (c) Naked Objects Group Ltd.
