package org.nakedobjects.nos.client.dnd.action;

import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.nof.core.reflect.Allow;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.drawing.Location;


public class IconizeViewOption extends AbstractUserAction {
    public IconizeViewOption() {
        super("Iconize");
    }

    public Consent disabled(final View view) {
        return Allow.DEFAULT;
    }

    public void execute(final Workspace workspace, final View view, final Location at) {
        View minimizedView = Toolkit.getViewFactory().createMinimizedView(view); 
        minimizedView.setLocation(view.getLocation());
        View[] views = workspace.getSubviews();
        for (int i = 0; i < views.length; i++) {
            if (views[i] == view) {
                // minimizedView.setParent(workspace);
                workspace.removeView(view);
                workspace.addView(minimizedView);
                workspace.invalidateLayout();
                return;
            }
        }

        /*
         * // TODO change so that an iconsized version of the window is created and displayed, which holds the
         * original view. View iconView = new RootIconSpecification().createView(view.getContent(), null);
         * iconView.setLocation(view.getLocation()); workspace.replaceView(view, iconView);
         */
    }

    public String getDescription(final View view) {
        return "Show this object as an icon on the workspace";
    }
}
// Copyright (c) Naked Objects Group Ltd.
