package org.nakedobjects.nos.client.dnd.action;

import org.apache.log4j.Logger;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.drawing.Location;


public class OpenViewOption extends AbstractUserAction {
    private static final Logger LOG = Logger.getLogger(OpenViewOption.class);
    private ViewSpecification specification;

    public OpenViewOption(final ViewSpecification builder) {
        super("Open as " + builder.getName());
        this.specification = builder;
    }

    public void execute(final Workspace workspace, final View view, final Location at) {
        View newView = specification.createView(view.getContent(), null);
        LOG.debug("open view " + newView);
        newView.setLocation(at);
        workspace.addView(newView);
        workspace.markDamaged();
    }

    public String getDescription(final View view) {
        String title = view.getContent().title();
        return "Open '" + title + "' in a " + specification.getName() + " window";
    }

    public String toString() {
        return super.toString() + " [prototype=" + specification.getName() + "]";
    }
}
// Copyright (c) Naked Objects Group Ltd.
