package org.nakedobjects.nos.client.dnd.action;

import org.apache.log4j.Logger;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.drawing.Location;


public class ReplaceViewOption extends AbstractUserAction {
    private static final Logger LOG = Logger.getLogger(ReplaceViewOption.class);
    private ViewSpecification specification;

    public ReplaceViewOption(final ViewSpecification specification) {
        super("View as " + specification.getName());
        this.specification = specification;
    }

    public String getDescription(final View view) {
        return "Replace this " + view.getSpecification().getName() + " view with a " + specification.getName() + " view";
    }

    public void execute(final Workspace workspace, final View view, final Location at) {
        View replacement = specification.createView(view.getContent(), view.getViewAxis());
    //    CompositeViewSpecification compositeViewSpecification = (CompositeViewSpecification) view.getParent().getSpecification();
    //    replacement = compositeViewSpecification.getSubviewBuilder().decorateSubview(replacement);
        LOG.debug("replacement view " + replacement);
        view.getParent().replaceView(view.getView(), replacement);
    }

    public String toString() {
        return super.toString() + " [prototype=" + specification.getName() + "]";
    }
}
// Copyright (c) Naked Objects Group Ltd.
