package org.nakedobjects.nos.client.dnd.action;

import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.noa.reflect.NakedObjectAction.Type;
import org.nakedobjects.nof.core.reflect.Veto;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.UserAction;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.drawing.Location;


public class ResizeWindowControl extends WindowControl {

    public ResizeWindowControl(final View target) {
        super(new UserAction() {

            public Consent disabled(final View view) {
                return Veto.DEFAULT;
            }

            public void execute(final Workspace workspace, final View view, final Location at) {}

            public String getDescription(final View view) {
                return "";
            }

            public String getHelp(final View view) {
                return "";
            }

            public Type getType() {
                return USER;
            }

            public String getName(final View view) {
                return "Resize";
            }
        }, target);

    }

    public void draw(final Canvas canvas) {
        int x = 0;
        int y = 0;

        canvas.drawRectangle(x + 1, y + 1, WIDTH - 1, HEIGHT - 1, Toolkit.getColor("white"));
        canvas.drawRectangle(x, y, WIDTH - 1, HEIGHT - 1, Toolkit.getColor("secondary1"));
        canvas.drawRectangle(x + 3, y + 2, 8, 8, Toolkit.getColor("secondary2"));
        canvas.drawLine(x + 3, y + 3, x + 10, y + 3, Toolkit.getColor("secondary2"));
    }
}
// Copyright (c) Naked Objects Group Ltd.
