package org.nakedobjects.nos.client.dnd.basic;

import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAreaType;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.view.simple.ObjectView;


public class FallbackView extends ObjectView {

    public static class Specification implements ViewSpecification {
        public boolean canDisplay(final Content content) {
            return true;
        }

        public View createView(final Content content, final ViewAxis axis) {
            return new FallbackView(content, this, axis);
        }

        public String getName() {
            return "Fallback";
        }

        public boolean isAligned() {
            return false;
        }

        public boolean isOpen() {
            return false;
        }

        public boolean isReplaceable() {
            return false;
        }

        public boolean isSubView() {
            return false;
        }
    }

    protected FallbackView(final Content content, final ViewSpecification specification, final ViewAxis axis) {
        super(content, specification, axis);
    }

    public void draw(final Canvas canvas) {
        super.draw(canvas);

        Size size = getSize();
        int width = size.getWidth() - 1;
        int height = size.getHeight() - 1;
        canvas.drawSolidRectangle(0, 0, width, height, Toolkit.getColor("secondary3"));
        canvas.drawSolidRectangle(0, 0, 10, height, Toolkit.getColor("secondary2"));
        canvas.drawLine(10, 0, 10, height - 2, Toolkit.getColor("black"));
        canvas.drawRectangle(0, 0, width, height, Toolkit.getColor("black"));
        canvas.drawText(getContent().title(), 14, getBaseline(), Toolkit.getColor("black"), Toolkit.getText("normal"));
    }

    public int getBaseline() {
        return 14;
    }

    public Size getMaximumSize() {
        return new Size(150, 20);
    }

    public ViewAreaType viewAreaType(final Location mouseLocation) {
        return mouseLocation.getX() <= 10 ? ViewAreaType.VIEW : ViewAreaType.CONTENT;
    }
}
// Copyright (c) Naked Objects Group Ltd.
