package org.nakedobjects.nos.client.dnd.basic;

import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.border.ObjectBorder;
import org.nakedobjects.nos.client.dnd.drawing.Text;
import org.nakedobjects.nos.client.dnd.view.graphic.IconGraphic;
import org.nakedobjects.nos.client.dnd.view.simple.Icon;
import org.nakedobjects.nos.client.dnd.view.text.ObjectTitleText;


public abstract class IconSpecification implements ViewSpecification {
    private boolean isSubView;
    private boolean isReplaceable;

    public IconSpecification() {
        this(true, true);
    }

    IconSpecification(boolean isSubView, boolean isReplaceable) {
        this.isSubView = isSubView;
        this.isReplaceable = isReplaceable;
    }

    public boolean canDisplay(final Content content) {
        return content.isObject() && content.getNaked() != null;
    }

    public View createView(final Content content, final ViewAxis axis) {
        Text style = Toolkit.getText("normal");
        Icon icon = new Icon(content, this, axis);
        icon.setTitle(new ObjectTitleText(icon, style));
        icon.setSelectedIcon(new IconGraphic(icon, style));
        return new ObjectBorder(new IconOpenAction(icon));
    }

    public String getName() {
        return "Icon";
    }

    public boolean isSubView() {
        return isSubView;
    }

    public boolean isReplaceable() {
        return isReplaceable;
    }

    public View decorateSubview(final View subview) {
        return subview;
    }

    public boolean isOpen() {
        return false;
    }
    
    public boolean isAligned() {
        return false;
    }
}
// Copyright (c) Naked Objects Group Ltd.
