package org.nakedobjects.nos.client.dnd.basic;

import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.ContentDrag;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.border.AbstractViewDecorator;
import org.nakedobjects.nos.client.dnd.drawing.Size;


public class Identifier extends AbstractViewDecorator {
    private boolean identified;

    public Identifier(final View wrappedView) {
        super(wrappedView);
    }

    public void debugDetails(final DebugString debug) {
        debug.append("Identifier");
    }

    public void dragIn(final ContentDrag drag) {
        wrappedView.dragIn(drag);
        markDamaged();
    }

    public void dragOut(final ContentDrag drag) {
        wrappedView.dragOut(drag);
        markDamaged();
    }

    public void draw(final Canvas canvas) {
        Size s = getSize();
        /*
         * if(identified) { canvas.drawSolidRectangle(0, 0, s.getWidth(), s.getHeight(), Toolkit.getColor("secondary2")); }
         * else if(dragover) { canvas.drawSolidRectangle(0, 0, s.getWidth(), s.getHeight(), Toolkit.getColor("primary3")); }
         * else {
         */canvas.drawSolidRectangle(0, 0, s.getWidth(), s.getHeight(), Toolkit.getColor("secondary3"));
        // }
        wrappedView.draw(canvas);
    }

    public void entered() {
        getState().setContentIdentified();
        wrappedView.entered();
        identified = true;
        markDamaged();
    }

    public void exited() {
        getState().clearObjectIdentified();
        wrappedView.exited();
        identified = false;
        markDamaged();
    }

    public String toString() {
        return wrappedView.toString() + "/Identifier [identified=" + identified + "]";
    }
}
// Copyright (c) Naked Objects Group Ltd.
