package org.nakedobjects.nos.client.dnd.basic;

import org.apache.log4j.Logger;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.util.NakedObjectConfiguration;
import org.nakedobjects.nos.client.dnd.Background;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.drawing.Image;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.image.ImageFactory;
import org.nakedobjects.nos.client.dnd.util.Properties;


public class LogoBackground implements Background {
    private static final Logger LOG = Logger.getLogger(LogoBackground.class);
    private static final String PARAMETER_BASE = Properties.PROPERTY_BASE + "logo-background.";
    private Location location;
    private Image logo;
    private Size logoSize;

    public LogoBackground() {
        NakedObjectConfiguration configuration = NakedObjectsContext.getConfiguration();
        
        String fileName = configuration.getString(PARAMETER_BASE + "image", "background");
        logo = ImageFactory.getInstance().loadImage(fileName);
        
        if (logo == null) {
          logo = ImageFactory.getInstance().loadImage("poweredby-logo");
        } 

        if (logo == null) {
            LOG.debug("logo image not found: " + fileName);
        } else {
            location = Properties.getLocation(PARAMETER_BASE + "location", new Location(-30, -30));
            logoSize = Properties.getSize(PARAMETER_BASE + "size", logo.getSize());
        }
    }

    public void draw(final Canvas canvas, final Size viewSize) {
        if (logo != null) {
            int x;
            int y;

            if (location.getX() == 0 && location.getY() == 0) {
                x = viewSize.getWidth() / 2 - logoSize.getWidth() / 2;
                y = viewSize.getHeight() / 2 - logoSize.getHeight() / 2;
            } else {
                x = (location.getX() >= 0) ? location.getX() : viewSize.getWidth() + location.getX() - logoSize.getWidth();
                y = (location.getY() >= 0) ? location.getY() : viewSize.getHeight() + location.getY() - logoSize.getHeight();
            }
            canvas.drawImage(logo, x, y, logoSize.getWidth(), logoSize.getHeight());
        }
    }
}
// Copyright (c) Naked Objects Group Ltd.
