package org.nakedobjects.nos.client.dnd.basic;

import org.nakedobjects.nos.client.dnd.Click;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.UserActionSet;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.action.AbstractUserAction;
import org.nakedobjects.nos.client.dnd.border.AbstractViewDecorator;
import org.nakedobjects.nos.client.dnd.border.ObjectBorder;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Text;
import org.nakedobjects.nos.client.dnd.view.graphic.IconGraphic;
import org.nakedobjects.nos.client.dnd.view.simple.Icon;
import org.nakedobjects.nos.client.dnd.view.text.ObjectTitleText;


class IconOpenAction extends AbstractViewDecorator {
    protected IconOpenAction(final View wrappedView) {
        super(wrappedView);
    }

    public void viewMenuOptions(final UserActionSet menuOptions) {
        super.viewMenuOptions(menuOptions);

        menuOptions.add(new AbstractUserAction("Open") {
            public void execute(final Workspace workspace, final View view, final Location at) {
                openIcon();
            }
        });

        menuOptions.add(new AbstractUserAction("Close") {
            public void execute(final Workspace workspace, final View view, final Location at) {
                getView().dispose();
             //   getWorkspace().removeObject((NakedObject) view.getContent().getNaked());
            }
        });
    }

    private void openIcon() {
        getWorkspace().addOpenViewFor(getContent().getNaked(), getLocation());
    }

    public void secondClick(final Click click) {
        openIcon();
    }
}

public class RootIconSpecification extends IconSpecification {
    public View createView(final Content content, final ViewAxis axis) {
        Icon icon = new Icon(content, this, axis);
        Text style = Toolkit.getText("normal");
        icon.setTitle(new ObjectTitleText(icon, style));
        icon.setSelectedIcon(new IconGraphic(icon, style));
        return new ObjectBorder(new IconOpenAction(icon));
    }
}
// Copyright (c) Naked Objects Group Ltd.
