package org.nakedobjects.nos.client.dnd.basic;

import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Drag;
import org.nakedobjects.nos.client.dnd.DragStart;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewDrag;
import org.nakedobjects.nos.client.dnd.border.AbstractBorder;
import org.nakedobjects.nos.client.dnd.drawing.Color;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Offset;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.view.simple.DragViewOutline;


public class SimpleBorder extends AbstractBorder {
    private int handleWidth = 14;

    public SimpleBorder(final View wrappedView) {
        this(1, wrappedView);
    }

    public SimpleBorder(final int size, final View wrappedView) {
        super(wrappedView);

        top = size;
        left = size;
        bottom = size;
        right = size + handleWidth;
    }

    protected void debugDetails(final DebugString debug) {
        debug.append("SimpleBorder " + top + " pixels\n");
        debug.append("           handle " + handleWidth + " pixels");
    }

    public Drag dragStart(final DragStart drag) {
        if (overBorder(drag.getLocation())) {
            Location location = drag.getLocation();
            DragViewOutline dragOverlay = new DragViewOutline(getView());
            return new ViewDrag(this, new Offset(location.getX(), location.getY()), dragOverlay);
        } else {
            return super.dragStart(drag);
        }
    }

    public void entered() {
        getState().setContentIdentified();
        getState().setViewIdentified();
        wrappedView.entered();
        markDamaged();
    }

    public void exited() {
        getState().clearObjectIdentified();
        getState().clearViewIdentified();
        wrappedView.exited();
        markDamaged();
    }

    public void draw(final Canvas canvas) {
        if (getState().isViewIdentified()) {
            Color color = Toolkit.getColor("secondary2");
            Size s = getSize();
            int width = s.getWidth();
            for (int i = 0; i < left; i++) {
                canvas.drawRectangle(i, i, width - 2 * i - 1, s.getHeight() - 2 * i - 1, color);
            }
            int w2 = width - left - 2;
            int w3 = w2 - handleWidth;
            for (int x = w2; x > w3; x -= 2) {
                canvas.drawLine(x, top, x, s.getHeight() - top, color);
            }
        }
        super.draw(canvas);
    }

    public String toString() {
        return wrappedView.toString() + "/SimpleBorder";
    }
}
// Copyright (c) Naked Objects Group Ltd.
