package org.nakedobjects.nos.client.dnd.basic;

import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.ContentDrag;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.border.AbstractViewDecorator;
import org.nakedobjects.nos.client.dnd.drawing.Color;
import org.nakedobjects.nos.client.dnd.drawing.Size;


public class SimpleIdentifier extends AbstractViewDecorator {

    public SimpleIdentifier(final View wrappedView) {
        super(wrappedView);
    }

    public void debugDetails(final DebugString debug) {
        debug.append("SimpleIdentifier");
    }

    public void dragIn(final ContentDrag drag) {
        wrappedView.dragIn(drag);
        markDamaged();
    }

    public void dragOut(final ContentDrag drag) {
        wrappedView.dragOut(drag);
        markDamaged();
    }

    public void draw(final Canvas canvas) {
        Color color = null;
        if (getState().canDrop()) {
            color = Toolkit.getColor("valid");
        } else if (getState().cantDrop()) {
            color = Toolkit.getColor("invalid");
        } else if (getState().isViewIdentified() || getState().isObjectIdentified()) {
            color = Toolkit.getColor("primary1");
        }

        wrappedView.draw(canvas.createSubcanvas());

        if (color != null) {
            Size s = getSize();
            canvas.drawRectangle(0, 0, s.getWidth() - 1, s.getHeight() - 1, color);
            canvas.drawRectangle(1, 1, s.getWidth() - 3, s.getHeight() - 3, color);
        }
    }

    public void entered() {
        getState().setContentIdentified();
        wrappedView.entered();
        markDamaged();
    }

    public void exited() {
        getState().clearObjectIdentified();
        wrappedView.exited();
        markDamaged();
    }

    public String toString() {
        return wrappedView.toString() + "/SimpleIdentifier";
    }
}
// Copyright (c) Naked Objects Group Ltd.
