package org.nakedobjects.nos.client.dnd.basic;

import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.OneToOneField;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.border.ObjectBorder;
import org.nakedobjects.nos.client.dnd.drawing.Text;
import org.nakedobjects.nos.client.dnd.lookup.OpenObjectDropDownBorder;
import org.nakedobjects.nos.client.dnd.view.graphic.IconGraphic;
import org.nakedobjects.nos.client.dnd.view.simple.Icon;
import org.nakedobjects.nos.client.dnd.view.text.ObjectTitleText;


public class SubviewIconSpecification extends IconSpecification {

    public View createView(final Content content, final ViewAxis axis) {
        Icon icon = new Icon(content, this, axis);
        Text style = Toolkit.getText("normal");
        icon.setTitle(new ObjectTitleText(icon, style));
        icon.setSelectedIcon(new IconGraphic(icon, style));
        if (content instanceof OneToOneField && ((OneToOneField) content).isEditable().isVetoed()) {
            return new ObjectBorder(icon);
        } else {
            if (content.isOptionEnabled()) {
                return new ObjectBorder(new OpenObjectDropDownBorder(icon));
            } else {
                return new ObjectBorder(icon);
            }
        }
    }

}
// Copyright (c) Naked Objects Group Ltd.
