package org.nakedobjects.nos.client.dnd.basic;

import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.drawing.Bounds;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.view.simple.AbstractView;


public class ViewResizeOutline extends AbstractView {
    private final int thickness = 1;
    private String label = "";
    private final Size size;

    protected ViewResizeOutline(final Bounds resizeArea) {
        super(null, null, null);
        size = resizeArea.getSize();
    }

    public void draw(final Canvas canvas) {
        super.draw(canvas);

        Size s = getSize();
        // Logger.getLogger(getClass()).debug("drag outline size " + s);
        for (int i = 0; i < thickness; i++) {
            canvas.drawRectangle(i, i, s.getWidth() - i * 2 - 1, s.getHeight() - i * 2 - 1, Toolkit.getColor("primary2"));
        }
        canvas.drawText(label, 2, 16, Toolkit.getColor("primary2"), Toolkit.getText("normal"));
    }

    public void setDisplay(final String label) {
        this.label = label == null ? "" : label;
    }

    public void dispose() {
        getFeedbackManager().showDefaultCursor();
        super.dispose();
    }

    public Size getMaximumSize() {
        return new Size(size);
    }
}
// Copyright (c) Naked Objects Group Ltd.
