package org.nakedobjects.nos.client.dnd.basic;

import org.nakedobjects.nof.core.context.Perspective;
import org.nakedobjects.nos.client.dnd.CompositeViewBuilder;
import org.nakedobjects.nos.client.dnd.CompositeViewSpecification;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.Workspace;


public class WorkspaceSpecification implements CompositeViewSpecification {
    ApplicationWorkspaceBuilder builder = new ApplicationWorkspaceBuilder();

    public View createView(final Content content, final ViewAxis axis) {
        Workspace workspace;
        workspace = new ApplicationWorkspace(content, this, axis);
//        workspace.setFocusManager(new WorkspaceFocusManager());
        return workspace;
    }

    public CompositeViewBuilder getSubviewBuilder() {
        return builder;
    }

    public String getName() {
        return "Root Workspace";
    }

    public boolean isAligned() {
        return false;
    }

    public boolean isOpen() {
        return true;
    }

    public boolean isReplaceable() {
        return false;
    }

    public boolean isSubView() {
        return false;
    }

    public boolean canDisplay(final Content content) {
        if(content.isObject()) {
            return content.getNaked().getSpecification().getFullName().equals(Perspective.class.getName());
        } else {
            return false;
        }
    }
}
// Copyright (c) Naked Objects Group Ltd.
