package org.nakedobjects.nos.client.dnd.basic;

import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.ValueContent;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.builder.AbstractFieldSpecification;
import org.nakedobjects.nos.client.dnd.view.field.WrappedTextField;


public class WrappedTextFieldSpecification extends AbstractFieldSpecification {
    public boolean canDisplay(final Content content) {
        return content.isValue() && content instanceof ValueContent && ((ValueContent) content).getNoLines() > 1;
    }

    public View createView(final Content content, final ViewAxis axis) {
        WrappedTextField wrappedTextField = new WrappedTextField((ValueContent) content, this, axis, true);
        wrappedTextField.setNoLines(((ValueContent) content).getNoLines());
        wrappedTextField.setWrapping(((ValueContent) content).canWrap());
        return new TextFieldResizeBorder(wrappedTextField);
    }

    public String getName() {
        return "Wrapped Text Field";
    }
    
    public boolean isAligned() {
        return true;
    }

}
// Copyright (c) Naked Objects Group Ltd.
