package org.nakedobjects.nos.client.dnd.border;

import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.action.CloseWindowControl;
import org.nakedobjects.nos.client.dnd.action.WindowControl;


public class DialogBorder extends AbstractWindowBorder {

    public DialogBorder(final View wrappedView, final boolean scrollable) {
        super(scrollable ? new ScrollBorder(wrappedView) : wrappedView);
        setControls(new WindowControl[] { new CloseWindowControl(this) });
    }

    protected String title() {
        return getContent().windowTitle();
    }

    public String toString() {
        return wrappedView.toString() + "/DialogBorder [" + getSpecification() + "]";
    }
}
// Copyright (c) Naked Objects Group Ltd.
