package org.nakedobjects.nos.client.dnd.border;

import org.nakedobjects.nos.client.dnd.Click;
import org.nakedobjects.nos.client.dnd.KeyboardAction;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.lookup.DropDownAxis;

import java.awt.event.KeyEvent;


public class DisposeOverlay extends AbstractViewDecorator {

    public DisposeOverlay(final View wrappedView) {
        super(wrappedView);
    }

    public Workspace getWorkspace() {
        View forView = ((DropDownAxis) getViewAxis()).getOriginalView();
        return forView.getWorkspace();
    }
    
    public void keyPressed(final KeyboardAction key) {
        if (key.getKeyCode() == KeyEvent.VK_ESCAPE) {
            dispose();
        }
        super.keyPressed(key);
    }

    public void dispose() {
        getViewManager().clearOverlayView(this);
    }
    
    public void firstClick(final Click click) {
        super.firstClick(click);
        dispose();
    }
}
// Copyright (c) Naked Objects Group Ltd.
