package org.nakedobjects.nos.client.dnd.border;

import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Drag;
import org.nakedobjects.nos.client.dnd.DragStart;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.drawing.Color;
import org.nakedobjects.nos.client.dnd.drawing.Size;


public class DisposedObjectBorder extends AbstractBorder {

    public DisposedObjectBorder(final int size, final View wrappedView) {
        super(wrappedView);
        top = size;
        left = size;
        bottom = size;
        right = size;
    }

    public DisposedObjectBorder(final View wrappedView) {
        this(2, wrappedView);
    }

    protected void debugDetails(final DebugString debug) {
        debug.append("DisposedObjectBorder " + top + " pixels");
    }

    public Drag dragStart(final DragStart drag) {
        return super.dragStart(drag);
    }

    public void draw(final Canvas canvas) {
        super.draw(canvas);

        Color color = null;
        color = Toolkit.getColor("invalid");
        Size s = getSize();

        int w = s.getWidth();
        int xExtent = s.getWidth() - left;
        for (int i = 0; i < left; i++) {
            canvas.drawRectangle(i, i, xExtent - 2 * i, s.getHeight() - 2 * i, color);
        }
        for (int i = 0; i < 15; i++) {
            canvas.drawLine(left, top + i, left + i, top, color);
            canvas.drawLine(w - left - right - 1, s.getHeight() - top - i - 1, w - left - right - i - 1, s.getHeight() - top - 1, color);
        }        
    }

    public void entered() {
        wrappedView.entered();
        getFeedbackManager().setError("Destroyed objects cannot be used");
        markDamaged();
    }

    public void exited() {
        wrappedView.exited();
        getFeedbackManager().setError("");
        markDamaged();
    }

    public String toString() {
        return wrappedView.toString() + "/DisposedObjectBorder [" + getSpecification() + "]";
    }
}
// Copyright (c) Naked Objects Group Ltd.
