package org.nakedobjects.nos.client.dnd.border;

import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.nof.core.reflect.Veto;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.ContentDrag;
import org.nakedobjects.nos.client.dnd.FieldContent;
import org.nakedobjects.nos.client.dnd.InternalDrag;
import org.nakedobjects.nos.client.dnd.ObjectContent;
import org.nakedobjects.nos.client.dnd.ParameterContent;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAreaType;
import org.nakedobjects.nos.client.dnd.ViewState;
import org.nakedobjects.nos.client.dnd.drawing.Color;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Text;


public class DroppableLabelBorder extends LabelBorder {
    
    public static View createObjectFieldLabelBorder(final View view) {
        final FieldContent fieldContent = (FieldContent) view.getContent();
        return createDroppableLabelBorder(fieldContent.getFieldName(), fieldContent.isMandatory(), view);
    }

    public static View createDroppableLabelBorder(String name, boolean mandatory, final View view) {
        Text style = mandatory ? Toolkit.getText("mandatory-label") : Toolkit.getText("label");
        return new DroppableLabelBorder(name, style, view);
    }
    
    public static View createObjectParameterLabelBorder(final View wrappedView) {
        ParameterContent parameterContent = (ParameterContent) wrappedView.getContent();
        return createDroppableLabelBorder(parameterContent.getParameterName(), parameterContent.isRequired(), wrappedView);
    }

    private ViewState labelState = new ViewState();
    private boolean overContent;

    protected DroppableLabelBorder(String label, Text style, View view) {
        super(label, style, view);
    }

    public ViewAreaType viewAreaType(Location location) {
        if (overBorder(location)) {
            return ViewAreaType.CONTENT; // used to ensure menu options for contained object are shown
        } else {
            return super.viewAreaType(location);
        }
    }

    public void dragCancel(final InternalDrag drag) {
        super.dragCancel(drag);
        labelState.clearViewIdentified();
    }

    public void drag(final ContentDrag drag) {
        Location targetLocation = drag.getTargetLocation();
        if (overContent(targetLocation) && overContent == false) {
            overContent = true;
            super.dragIn(drag);
            dragOutOfLabel();
        } else if (overBorder(targetLocation) && overContent == true) {
            overContent = false;
            super.dragOut(drag);
            dragInToLabel(drag.getSourceContent());
        }

        super.drag(drag);
    }

    public void dragIn(final ContentDrag drag) {
        if (overContent(drag.getTargetLocation())) {
            super.dragIn(drag);
        } else {
            Content sourceContent = drag.getSourceContent();
            dragInToLabel(sourceContent);
            markDamaged();
        }
    }

    private void dragInToLabel(Content sourceContent) {
        overContent = false;
        Consent canDrop = canDrop(sourceContent);
        if (canDrop.isAllowed()) {
            labelState.setCanDrop();
        } else {
            labelState.setCantDrop();
        }
        if (!canDrop.getReason().equals("")) {
            getFeedbackManager().setAction(canDrop.getReason());
        } else {
            getFeedbackManager().setAction("Set to " + sourceContent.title());
        }
    }

    public void dragOut(ContentDrag drag) {
        super.dragOut(drag);
        dragOutOfLabel();
    }

    private void dragOutOfLabel() {
        labelState.clearObjectIdentified();
        markDamaged();
    }

    public void drop(final ContentDrag drag) {
        if (overContent(drag.getTargetLocation())) {
            super.drop(drag);
        } else {
            dragOutOfLabel();
            Content sourceContent = drag.getSourceContent();
            if (canDrop(sourceContent).isAllowed()) {
                drop(sourceContent);
            }
        }
    }

    protected Consent canDrop(final Content dropContent) {
        if (dropContent instanceof ObjectContent) {
            NakedObject source = ((ObjectContent) dropContent).getObject();
            ObjectContent content = (ObjectContent) getContent();
            return content.canSet(source);
        } else {
            return Veto.DEFAULT;
        }        
    }

    protected void drop(Content dropContent) {
        if (dropContent instanceof ObjectContent) {
            NakedObject object = ((ObjectContent) dropContent).getObject();
            ((ObjectContent) getContent()).setObject(object);
            getParent().invalidateContent();
        }
    }
    
    protected Color textColor() {
        Color color;
        if (labelState.canDrop()) {
            color = Toolkit.getColor("valid");
        } else if (labelState.cantDrop()) {
            color = Toolkit.getColor("invalid");
        } else {
            color = DEFAULT_COLOR;
        }
        return color;
    }
}

// Copyright (c) Naked Objects Group Ltd.
