package org.nakedobjects.nos.client.dnd.border;

import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.ContentDrag;
import org.nakedobjects.nos.client.dnd.Drag;
import org.nakedobjects.nos.client.dnd.DragStart;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAreaType;
import org.nakedobjects.nos.client.dnd.drawing.Bounds;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.drawing.Text;
import org.nakedobjects.nos.client.dnd.view.graphic.IconGraphic;
import org.nakedobjects.nos.client.dnd.view.text.ObjectTitleText;
import org.nakedobjects.nos.client.dnd.view.text.TitleText;


public class IconBorder extends AbstractBorder {
    private final static Text TITLE_STYLE = Toolkit.getText("title");
    private int baseline;
    private int titlebarHeight;
    private int padding = 0;

    private IconGraphic icon;
    private TitleText text;

    public IconBorder(final View wrappedView) {
        super(wrappedView);

        icon = new IconGraphic(this, TITLE_STYLE);
        text = new ObjectTitleText(this, TITLE_STYLE);
        titlebarHeight = icon.getSize().getHeight() + 1;

        top = titlebarHeight;

        baseline = icon.getBaseline() + 1;
    }

    public void debugDetails(final DebugString debug) {
        debug.append("IconBorder " + left + " pixels\n");
        debug.append("           titlebar " + (top - titlebarHeight) + " pixels");
        super.debugDetails(debug);
    }

    public Drag dragStart(final DragStart drag) {
        if (overBorder(drag.getLocation())) {
            View dragOverlay = Toolkit.getViewFactory().getContentDragSpecification().createView(getContent(), null);
            return new ContentDrag(this, drag.getLocation(), dragOverlay);
        } else {
            return super.dragStart(drag);
        }
    }

    public void draw(final Canvas canvas) {
        int x = left + HPADDING;

        if (Toolkit.debug) {
            canvas.drawDebugOutline(new Bounds(getSize()), baseline, Toolkit.getColor("debug.bounds.draw"));
        }

        // icon & title
        icon.draw(canvas, x, baseline);
        x += icon.getSize().getWidth();
        x += View.HPADDING;
        text.draw(canvas, x, baseline);

        // components
        super.draw(canvas);
    }

    public int getBaseline() {
        return wrappedView.getBaseline() + baseline + titlebarHeight;
    }

    public Size getRequiredSize(final Size maximumSize) {
        Size size = super.getRequiredSize(maximumSize);
        size.ensureWidth(left + icon.getSize().getWidth() + View.HPADDING + text.getSize().getWidth() + padding + right);
        return size;
    }

    public ViewAreaType viewAreaType(final Location mouseLocation) {
        Bounds title = new Bounds(new Location(), icon.getSize());
        title.extendWidth(left);
        title.extendWidth(text.getSize().getWidth());
        if (title.contains(mouseLocation)) {
            return ViewAreaType.CONTENT;
        } else {
            return super.viewAreaType(mouseLocation);
        }
    }

    public String toString() {
        return wrappedView.toString() + "/WindowBorder [" + getSpecification() + "]";
    }
}
// Copyright (c) Naked Objects Group Ltd.
