package org.nakedobjects.nos.client.dnd.border;

import org.nakedobjects.nof.core.util.ToString;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.LabelAxis;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewState;
import org.nakedobjects.nos.client.dnd.drawing.Color;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.drawing.Text;
import org.nakedobjects.nos.client.dnd.view.simple.AbstractView;


public class Label extends AbstractView {
    private static final Color DEFAULT_COLOR = Toolkit.getColor("primary1");
    protected final String label;
    private final Text style;
    private int width;
    private int baseline;

    public Label(final String label, final Text style, View view) {
        this.label = label + ":";
        this.style = style;
        this.baseline = style.getAscent();
        setContent(view.getContent());
        setViewAxis(view.getViewAxis());

        int width = HPADDING + style.stringWidth(this.label) + HPADDING;
        if (getViewAxis() == null) {
            this.width = width;
        } else {
            ((LabelAxis) getViewAxis()).accommodateWidth(width);
        }
    }

    public int getBaseline() {
        return baseline;
    }
    
    protected int getLeft() {
        if (getViewAxis() == null) {
            return width;
        } else {
            return ((LabelAxis) getViewAxis()).getWidth();
        }
    }
    
    protected void debugDetails(final StringBuffer b) {
        b.append("Label '" + label + "'");
    }

    public void draw(final Canvas canvas) {
        ViewState state = getState();
        Color color;
        if (state.canDrop()) {
            color = Toolkit.getColor("valid");
        } else if (state.cantDrop()) {
            color = Toolkit.getColor("invalid");
        } else {
            color = DEFAULT_COLOR;
        }
        canvas.drawText(label, HPADDING, baseline, color, style);
        super.draw(canvas);
    }

    public Size getMaximumSize() {
        return new Size(getLeft(), style.getLineHeight());
    }

    public String toString() {
        return ToString.name(this);
    }
}
// Copyright (c) Naked Objects Group Ltd.
