package org.nakedobjects.nos.client.dnd.border;

import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nof.core.util.ToString;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.FieldContent;
import org.nakedobjects.nos.client.dnd.LabelAxis;
import org.nakedobjects.nos.client.dnd.ParameterContent;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.drawing.Color;
import org.nakedobjects.nos.client.dnd.drawing.Text;


public class LabelBorder extends AbstractBorder {
    
    public static View createFieldLabelBorder(final View wrappedView) {
        FieldContent fieldContent = (FieldContent) wrappedView.getContent();
        return createLabelBorder(fieldContent.getFieldName(), fieldContent.isMandatory(), wrappedView);
    }

    public static View createLabelBorder(String name, boolean mandatory, final View wrappedView) {
        Text style = mandatory ? Toolkit.getText("mandatory-label") : Toolkit.getText("label");
        return new LabelBorder(name, style, wrappedView);
    }

    public static View createValueParameterLabelBorder(final View wrappedView) {
        ParameterContent fieldContent = (ParameterContent) wrappedView.getContent();
        return createLabelBorder(fieldContent.getParameterName(), fieldContent.isRequired(), wrappedView);
    }
    
    protected static final Color DEFAULT_COLOR = Toolkit.getColor("primary1");
    private final String label;
    private final Text style;

    public LabelBorder(final String label, final View wrappedView) {
        this(label, Toolkit.getText("label"), wrappedView);
    }

    public LabelBorder(final String label, final Text style, final View wrappedView) {
        super(wrappedView);
        this.label = label + ":";
        this.style = style;

        int width = HPADDING + style.stringWidth(this.label) + HPADDING;
        if (getViewAxis() == null) {
            left = width;
        } else {
            ((LabelAxis) getViewAxis()).accommodateWidth(width);
        }
    }

    protected int getLeft() {
        if (getViewAxis() == null) {
            return left;
        } else {
            return ((LabelAxis) getViewAxis()).getWidth();
        }
    }

    public void debugDetails(final DebugString debug) {
        super.debugDetails(debug);
        debug.appendln("label", "'"+ label + "'");
    }

    public void draw(final Canvas canvas) {
        Color color = textColor();
        canvas.drawText(label, HPADDING, wrappedView.getBaseline(), color, style);
        super.draw(canvas);
    }

    protected Color textColor() {
        return DEFAULT_COLOR;
    }

    public String toString() {
        return wrappedView.toString() + "/" + ToString.name(this);
    }
}
// Copyright (c) Naked Objects Group Ltd.
