package org.nakedobjects.nos.client.dnd.border;

import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.drawing.Color;
import org.nakedobjects.nos.client.dnd.drawing.Size;


public class LineBorder extends AbstractBorder {
    private final Color color;

    public LineBorder(final View wrappedView) {
        this(1, wrappedView);
    }

    public LineBorder(final int size, final View wrappedView) {
        this(size, Toolkit.getColor("black"), wrappedView);
    }

    public LineBorder(final Color color, final View wrappedView) {
        this(1, color, wrappedView);
    }

    public LineBorder(final int size, final Color color, final View wrappedView) {
        super(wrappedView);

        top = size;
        left = size;
        bottom = size;
        right = size;

        this.color = color;
    }

    protected void debugDetails(final DebugString debug) {
        debug.append("LineBorder " + top + " pixels\n");
    }

    public void draw(final Canvas canvas) {
        Size s = getSize();
        int width = s.getWidth();
        for (int i = 0; i < left; i++) {
            canvas.drawRectangle(i, i, width - 2 * i, s.getHeight() - 2 * i, color);
        }
        super.draw(canvas);
    }

    public String toString() {
        return wrappedView.toString() + "/LineBorder";
    }
}
// Copyright (c) Naked Objects Group Ltd.
