package org.nakedobjects.nos.client.dnd.border;

import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Drag;
import org.nakedobjects.nos.client.dnd.DragStart;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewDrag;
import org.nakedobjects.nos.client.dnd.ViewState;
import org.nakedobjects.nos.client.dnd.drawing.Color;
import org.nakedobjects.nos.client.dnd.drawing.Image;
import org.nakedobjects.nos.client.dnd.drawing.Offset;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.image.ImageFactory;
import org.nakedobjects.nos.client.dnd.view.simple.DragViewOutline;


public class ObjectBorder extends AbstractBorder {
    private static final int BORDER = 13;

    public ObjectBorder(final int size, final View wrappedView) {
        super(wrappedView);

        top = size;
        left = size;
        bottom = size;
        right = size + BORDER;
    }

    public ObjectBorder(final View wrappedView) {
        this(1, wrappedView);
    }

    protected void debugDetails(final DebugString debug) {
        super.debugDetails(debug);
        debug.appendln("border", top + " pixel(s)");
    }

    public Drag dragStart(final DragStart drag) {
        if (drag.getLocation().getX() > getSize().getWidth() - right) {
            if (getContent().getNaked() == null) {
                return null;
            }
            View dragOverlay = new DragViewOutline(getView());
            return new ViewDrag(this, new Offset(drag.getLocation()), dragOverlay);
        } else {
            return super.dragStart(drag);
        }
    }

    public void draw(final Canvas canvas) {
        super.draw(canvas);

        Color color = null;
        ViewState state = getState();
        boolean hasFocus = getViewManager().hasFocus(getView());
        if (state.canDrop()) {
            color = Toolkit.getColor("valid");
        } else if (state.cantDrop()) {
            color = Toolkit.getColor("invalid");
        } else if (hasFocus) {
            color = Toolkit.getColor("identified");
        } else if (state.isObjectIdentified()) {
            color = Toolkit.getColor("secondary2");
        }
        Size s = getSize();

        if (getContent().isPersistable() && getContent().isTransient()) {
            int x = s.getWidth() - 13;
            int y = 0;
            Image icon = ImageFactory.getInstance().loadIcon("transient", 8, null);
            if (icon == null) {
                canvas.drawText("*", x, y + Toolkit.getText("normal").getAscent(), Toolkit.getColor("black"), Toolkit.getText("normal"));
            } else {
                canvas.drawImage(icon, x, y, 12, 12);
            }
        }

        if (color != null) {
            if (hasFocus) {
                int xExtent = s.getWidth() - left;
                for (int i = 0; i < left; i++) {
                    canvas.drawRectangle(i, i, xExtent - 2 * i, s.getHeight() - 2 * i, color);
                }
            } else {
                int xExtent = s.getWidth();
                for (int i = 0; i < left; i++) {
                    canvas.drawRectangle(i, i, xExtent - 2 * i, s.getHeight() - 2 * i, color);
                }
                canvas.drawLine(xExtent - BORDER, top, xExtent - BORDER, top + s.getHeight(), color);
                canvas.drawSolidRectangle(xExtent - BORDER + 1, top, BORDER - 2, s.getHeight() - 2 * top, Toolkit.getColor("secondary3"));
            }
        }
    }

    public void entered() {
        getState().setContentIdentified();
        getState().setViewIdentified();
        wrappedView.entered();
        markDamaged();
    }

    public void exited() {
        getState().clearObjectIdentified();
        getState().clearViewIdentified();
        wrappedView.exited();
        markDamaged();
    }

    public String toString() {
        return wrappedView.toString() + "/ObjectBorder [" + getSpecification() + "]";
    }
}
// Copyright (c) Naked Objects Group Ltd.
