package org.nakedobjects.nos.client.dnd.border;

import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.drawing.Color;


public class PanelBorder extends LineBorder {
    private Color background;

    public PanelBorder(final View wrappedView) {
        super(wrappedView);
        background = Toolkit.getColor("white");
    }

    public PanelBorder(final int size, final Color border, final Color background, final View wrappedView) {
        super(size, border, wrappedView);
        this.background = background;
    }

    public PanelBorder(final int size, final View wrappedView) {
        super(size, Toolkit.getColor("secondary2"), wrappedView);
        background = Toolkit.getColor("white");
    }

    public PanelBorder(final Color border, final Color background, final View wrappedView) {
        super(border, wrappedView);
        this.background = background;
    }

    public void draw(final Canvas canvas) {
        canvas.clearBackground(this, background);
        super.draw(canvas);
    }

    public void setBackground(final Color color) {
        this.background = color;
    }

    public String toString() {
        return wrappedView.toString() + "/PanelBorder";
    }
}
// Copyright (c) Naked Objects Group Ltd.
