package org.nakedobjects.nos.client.dnd.border;

import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Click;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.UserActionSet;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.action.CloseWindowControl;
import org.nakedobjects.nos.client.dnd.action.IconizeViewOption;
import org.nakedobjects.nos.client.dnd.action.IconizeWindowControl;
import org.nakedobjects.nos.client.dnd.action.ResizeWindowControl;
import org.nakedobjects.nos.client.dnd.action.WindowControl;
import org.nakedobjects.nos.client.dnd.drawing.Image;
import org.nakedobjects.nos.client.dnd.image.ImageFactory;


public class WindowBorder extends AbstractWindowBorder {
    private static final IconizeViewOption iconizeOption = new IconizeViewOption();

    public WindowBorder(final View wrappedView, final boolean scrollable) {
        super(addTransientBorderIfNeccessary(scrollable ? new ScrollBorder(wrappedView) : wrappedView));

        if (isTransient()) {
            setControls(new WindowControl[] { new CloseWindowControl(this) });
        } else {
            setControls(new WindowControl[] { new IconizeWindowControl(this), new ResizeWindowControl(this),
                    new CloseWindowControl(this) });
        }
    }

    private static View addTransientBorderIfNeccessary(final View view) {
        Content content = view.getContent();
        if (content.isPersistable() && content.isTransient()) {
            return new SaveTransientObjectBorder(view);
        } else {
            return view;
        }
    }

    /* TODO fix focus management and remove this hack */
    public View[] getButtons() {
        if(wrappedView instanceof ButtonBorder) {
            return ((ButtonBorder) wrappedView).getButtons();
        } else {
            return new View[0];
        }
    }
    
    public void draw(final Canvas canvas) {
        super.draw(canvas);

        if (isTransient()) {
            int height = top - LINE_THICKNESS - 2;
            int x = getSize().getWidth() - 50;
            Image icon = ImageFactory.getInstance().loadIcon("transient", height, null);
            if (icon == null) {
                canvas.drawText("*", x, getBaseline(), Toolkit.getColor("black"), Toolkit.getText("normal"));
            } else {
                canvas.drawImage(icon, x, LINE_THICKNESS + 1, height, height);
                // canvas.drawRectangle(x, LINE_THICKNESS + 1, height, height, Color.RED);
            }
        }
    }

    private boolean isTransient() {
        Content content = getContent();
        return content.isPersistable() && content.isTransient();
    }

    public void viewMenuOptions(final UserActionSet menuOptions) {
        super.viewMenuOptions(menuOptions);
        menuOptions.add(iconizeOption);
    }

    public void secondClick(final Click click) {
        if (overBorder(click.getLocation())) {
            iconizeOption.execute(getWorkspace(), getView(), getAbsoluteLocation());
        } else {
            super.secondClick(click);
        }
    }

    protected String title() {
        return getContent().windowTitle();
    }

    public String toString() {
        return wrappedView.toString() + "/WindowBorder [" + getSpecification() + "]";
    }
}
// Copyright (c) Naked Objects Group Ltd.
