package org.nakedobjects.nos.client.dnd.builder;

import org.nakedobjects.nos.client.dnd.CompositeViewBuilder;
import org.nakedobjects.nos.client.dnd.CompositeViewSpecification;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.drawing.Size;


public abstract class AbstractBuilderDecorator implements CompositeViewBuilder {
    protected final CompositeViewBuilder wrappedBuilder;

    public AbstractBuilderDecorator(final CompositeViewBuilder design) {
        this.wrappedBuilder = design;
        wrappedBuilder.setReference(this);
    }

    public void build(final View view) {
        wrappedBuilder.build(view);
    }

    public View createCompositeView(final Content content, final CompositeViewSpecification specification, final ViewAxis axis) {
        return wrappedBuilder.createCompositeView(content, specification, axis);
    }

    public ViewAxis createViewAxis() {
        return wrappedBuilder.createViewAxis();
    }

    public View decorateSubview(final View subview) {
        return wrappedBuilder.decorateSubview(subview);
    }

    public CompositeViewBuilder getReference() {
        return wrappedBuilder.getReference();
    }

    public Size getRequiredSize(final View view) {
        return wrappedBuilder.getRequiredSize(view);
    }

    public boolean isOpen() {
        return wrappedBuilder.isOpen();
    }

    public boolean isReplaceable() {
        return wrappedBuilder.isReplaceable();
    }

    public boolean isSubView() {
        return wrappedBuilder.isSubView();
    }

    public void layout(final View view, final Size maximumSize) {
        wrappedBuilder.layout(view, new Size());
    }

    public void setReference(final CompositeViewBuilder design) {
        wrappedBuilder.setReference(design);
    }

    public String toString() {
        String name = getClass().getName();
        return wrappedBuilder + "/" + name.substring(name.lastIndexOf('.') + 1);
    }
}
// Copyright (c) Naked Objects Group Ltd.
