package org.nakedobjects.nos.client.dnd.builder;

import org.nakedobjects.nof.core.util.NotImplementedException;
import org.nakedobjects.nos.client.dnd.CompositeViewBuilder;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.drawing.Size;


public abstract class AbstractViewBuilder implements CompositeViewBuilder {
    private CompositeViewBuilder reference;

    public abstract void build(final View view);

    public ViewAxis createViewAxis() {
        return null;
    }

    public View decorateSubview(final View subview) {
        return subview;
    }

    public CompositeViewBuilder getReference() {
        return reference;
    }

    public Size getRequiredSize(final View view) {
        throw new NotImplementedException();
    }

    public boolean isOpen() {
        return false;
    }

    public boolean isReplaceable() {
        return false;
    }

    public boolean isSubView() {
        return false;
    }

    public void layout(final View view, final Size maximumSize) {}

    public void setReference(final CompositeViewBuilder design) {
        this.reference = design;
    }

    public String toString() {
        String name = getClass().getName();
        return name.substring(name.lastIndexOf('.') + 1);
    }
}
// Copyright (c) Naked Objects Group Ltd.
