package org.nakedobjects.nos.client.dnd.builder;

import java.util.Enumeration;

import org.apache.log4j.Logger;
import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.reflect.OneToManyAssociation;
import org.nakedobjects.nof.core.util.Assert;
import org.nakedobjects.nos.client.dnd.CollectionContent;
import org.nakedobjects.nos.client.dnd.CompositeViewSpecification;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.OneToManyField;
import org.nakedobjects.nos.client.dnd.SubviewSpec;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.content.CollectionElement;
import org.nakedobjects.nos.client.dnd.content.OneToManyFieldElementImpl;
import org.nakedobjects.nos.client.dnd.view.simple.CompositeView;


public class CollectionElementBuilder extends AbstractViewBuilder {
    private static final Logger LOG = Logger.getLogger(CollectionElementBuilder.class);
    private boolean canDragView = true;
    private SubviewSpec subviewDesign;

    public CollectionElementBuilder(final SubviewSpec subviewDesign) {
        this.subviewDesign = subviewDesign;
    }

    public void build(final View view) {
        Assert.assertEquals(view.getView(), view);

        Content content = view.getContent();
        OneToManyAssociation field = content instanceof OneToManyField ? ((OneToManyField) content).getOneToManyAssociation()
                : null;

        LOG.debug("rebuild view " + view + " for " + content);

        CollectionContent collectionContent = ((CollectionContent) content);
        Enumeration elements;
        elements = collectionContent.allElements();

        /*
         * remove all subviews from the view and then work through the elements of the collection adding in a
         * view for each element. Where a subview for the that element already exists it should be reused.
         */
        View[] subviews = view.getSubviews();
        Naked[] existingElements = new NakedObject[subviews.length];
        for (int i = 0; i < subviews.length; i++) {
            view.removeView(subviews[i]);
            existingElements[i] = subviews[i].getContent().getNaked();
        }

        while (elements.hasMoreElements()) {
            NakedObject element = (NakedObject) elements.nextElement();
            View elementView = null;
            for (int i = 0; i < subviews.length; i++) {
                if (existingElements[i] == element) {
                    elementView = subviews[i];
                    existingElements[i] = null;
                    break;
                }
            }
            if (elementView == null) {
                Content elementContent;
                if (field == null) {
                    elementContent = new CollectionElement(element);
                } else {
                    Naked obj = ((OneToManyField) view.getContent()).getParent();
                    // Naked obj = view.getParent().getContent().getNaked();
                    NakedObject parent = (NakedObject) obj;
                    elementContent = new OneToManyFieldElementImpl(parent, element, field);
                }
                elementView = subviewDesign.createSubview(elementContent, view.getViewAxis());
            }
            if (elementView != null) {
                view.addView(elementView);
            }
        }
    }

    public View createCompositeView(final Content content, final CompositeViewSpecification specification, final ViewAxis axis) {
        CompositeView view = new CompositeView(content, specification, axis);
        view.setCanDragView(canDragView);
        return view;
    }

    public void setCanDragView(final boolean canDragView) {
        this.canDragView = canDragView;
    }
}
// Copyright (c) Naked Objects Group Ltd.
