package org.nakedobjects.nos.client.dnd.builder;

import org.nakedobjects.nos.client.dnd.CompositeViewBuilder;
import org.nakedobjects.nos.client.dnd.LabelAxis;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Size;


public class LabelledFieldLayout extends AbstractBuilderDecorator {

    public LabelledFieldLayout(final CompositeViewBuilder design) {
        super(design);
    }

    public Size getRequiredSize(final View view) {
        int height = 0;
        int width = 0;
        View views[] = view.getSubviews();

        for (int i = 0; i < views.length; i++) {
            View v = views[i];
            Size s = v.getRequiredSize(new Size());
            height = Math.max(height, s.getHeight());
            width += s.getWidth();
        }
        width += View.HPADDING;

        return new Size(width, height);
    }

    public boolean isOpen() {
        return false;
    }

    public void layout(final View view, final Size maximumSize) {
        int x = 0, y = 0;
        View subviews[] = view.getSubviews();
        for (int i = 0; i < subviews.length; i++) {
            View v = subviews[i];
            v.layout(maximumSize);
            Size s = v.getRequiredSize(new Size());
            v.setSize(s);
            v.setLocation(new Location(x, y));

            x = ((LabelAxis) v.getViewAxis()).getWidth() + View.HPADDING;
        }
    }

}
// Copyright (c) Naked Objects Group Ltd.
