package org.nakedobjects.nos.client.dnd.content;

import java.util.Enumeration;

import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedCollection;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.ResolveState;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.reflect.AbstractConsent;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nof.core.util.UnexpectedCallException;
import org.nakedobjects.nos.client.dnd.CollectionContent;
import org.nakedobjects.nos.client.dnd.CollectionSorter;
import org.nakedobjects.nos.client.dnd.Comparator;
import org.nakedobjects.nos.client.dnd.UserAction;
import org.nakedobjects.nos.client.dnd.UserActionSet;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.action.AbstractUserAction;
import org.nakedobjects.nos.client.dnd.drawing.Image;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.image.ImageFactory;


public abstract class AbstractCollectionContent extends AbstractContent implements CollectionContent {
    private static final TypeComparator TYPE_COMPARATOR = new TypeComparator();
    private static final TitleComparator TITLE_COMPARATOR = new TitleComparator();
    private final static CollectionSorter sorter = new SimpleCollectionSorter();
    private Comparator order;
    private boolean reverse;

    public final Enumeration allElements() {
        final NakedObject[] elements = elements();

        sorter.sort(elements, order, reverse);

        return new Enumeration() {
            int i = 0;
            int size = elements.length;

            public boolean hasMoreElements() {
                return i < size;
            }

            public Object nextElement() {
                return elements[i++];
            }
        };
    }

    public void debugDetails(final DebugString debug) {
        debug.appendln("order", order);
        debug.appendln("reverse order", reverse);
    }

    public NakedObject[] elements() {
        NakedCollection collection = getCollection();
        if (collection == null) {
            return new NakedObject[0];
        }
        
        final NakedObject[] elementsArray = new NakedObject[collection.size()];
        int i = 0;
        Enumeration elements = collection.elements();
        while (elements.hasMoreElements()) {
            elementsArray[i++] = (NakedObject) elements.nextElement();
        }
        return elementsArray;
    }

    public abstract NakedCollection getCollection();

    public String getDescription() {
        return "Collection";
    }

    public void contentMenuOptions(final UserActionSet options) {
        final NakedCollection collection = getCollection();

        OptionFactory.addObjectMenuOptions(collection, options);

        // TODO find all collection actions, and make them available
        // not valid ObjectOption.menuOptions((NakedObject) object, options);
        /*
         * Action[] actions = collection.getSpecification().getObjectActions(Action.USER);
         * 
         * for (int i = 0; i < actions.length; i++) { final Action action = actions[i]; AbstractUserAction
         * option; option = new AbstractUserAction(actions[i].getId()) { public void execute(final Workspace
         * workspace, final View view, final Location at) { Naked result = collection.execute(action, new
         * Naked[0]); at.add(20, 20); workspace.addOpenViewFor(result, at); } };
         * 
         * if (option != null) { options.add(option); } }
         */
        options.add(new AbstractUserAction("Clear resolved", UserAction.DEBUG) {
            public Consent disabled(final View component) {
                return AbstractConsent.allow(collection == null || collection.getResolveState() != ResolveState.TRANSIENT
                        || collection.getResolveState() == ResolveState.GHOST);
            }

            public void execute(final Workspace workspace, final View view, final Location at) {
                collection.changeState(ResolveState.GHOST);
            }
        });

    }

    public void viewMenuOptions(final UserActionSet options) {
        UserActionSet sortOptions = new UserActionSet("Sort", options);
        options.add(sortOptions);

        sortOptions.add(new AbstractUserAction("Clear") {
            public Consent disabled(final View component) {
                return AbstractConsent.allow(order != null);
            }

            public void execute(final Workspace workspace, final View view, final Location at) {
                order = null;
                view.invalidateContent();
            }
        });

        if (reverse) {
            sortOptions.add(new AbstractUserAction("Normal sort order") {
                public Consent disabled(final View component) {
                    return AbstractConsent.allow(order != null);
                }

                public void execute(final Workspace workspace, final View view, final Location at) {
                    reverse = false;
                    view.invalidateContent();
                }
            });
        } else {
            sortOptions.add(new AbstractUserAction("Reverse sort order") {
                public Consent disabled(final View component) {
                    return AbstractConsent.allow(order != null);
                }

                public void execute(final Workspace workspace, final View view, final Location at) {
                    reverse = true;
                    view.invalidateContent();
                }
            });
        }

        sortOptions.add(new AbstractUserAction("Sort by title") {
            public Consent disabled(final View component) {
                return AbstractConsent.allow(order != TITLE_COMPARATOR);
            }

            public void execute(final Workspace workspace, final View view, final Location at) {
                order = TITLE_COMPARATOR;
                view.invalidateContent();
            }
        });

        sortOptions.add(new AbstractUserAction("Sort by type") {
            public Consent disabled(final View component) {
                return AbstractConsent.allow(order != TYPE_COMPARATOR);
            }

            public void execute(final Workspace workspace, final View view, final Location at) {
                order = TYPE_COMPARATOR;
                view.invalidateContent();
            }
        });

        NakedCollection c = getCollection();
        if (c instanceof NakedCollection) {
            NakedObjectSpecification spec = ((NakedCollection) c).getElementSpecification();
            NakedObjectField[] fields = spec.getFields();
            for (int i = 0; i < fields.length; i++) {
                final NakedObjectField field = fields[i];

                sortOptions.add(new AbstractUserAction("Sort by " + field.getName()) {
                    public void execute(final Workspace workspace, final View view, final Location at) {
                        order = new FieldComparator(field);
                        view.invalidateContent();
                    }
                });
            }
        }
    }

    public void parseTextEntry(final String entryText) {
        throw new UnexpectedCallException();
    }

    public void setOrder(final Comparator order) {
        this.order = order;
    }

    public void setOrderByField(final NakedObjectField field) {
        if (order instanceof FieldComparator && ((FieldComparator) order).getField() == field) {
            reverse = !reverse;
        } else {
            order = new FieldComparator(field);
            reverse = false;
        }
    }

    public void setOrderByElement() {
        if (order == TITLE_COMPARATOR) {
            reverse = !reverse;
        } else {
            order = TITLE_COMPARATOR;
            reverse = false;
        }
    }

    public NakedObjectField getFieldSortOrder() {
        if (order instanceof FieldComparator) {
            return ((FieldComparator) order).getField();
        } else {
            return null;
        }
    }

    public Image getIconPicture(final int iconHeight) {
        NakedCollection nakedObject = getCollection();
        if (nakedObject == null) {
            return ImageFactory.getInstance().loadIcon("emptyField", iconHeight, null);
        }
        NakedObjectSpecification specification = nakedObject.getSpecification();
        Image icon = ImageFactory.getInstance().loadIcon(specification, iconHeight, null);
        if (icon == null) {
            icon = ImageFactory.getInstance().loadDefaultIcon(iconHeight, null);
        }
        return icon;
    }

    public boolean getOrderByElement() {
        return order == TITLE_COMPARATOR;
    }

    public boolean getReverseSortOrder() {
        return reverse;
    }

    public boolean isOptionEnabled() {
        return false;
    }

    public Naked[] getOptions() {
        return null;
    }
}
// Copyright (c) Naked Objects Group Ltd.
