package org.nakedobjects.nos.client.dnd.content;

import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedCollection;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.NakedValue;
import org.nakedobjects.noa.adapter.Persistable;
import org.nakedobjects.noa.adapter.ResolveState;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.noa.reflect.NakedObjectAction;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.noa.reflect.OneToOneAssociation;
import org.nakedobjects.noa.reflect.ValueAssociation;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.persist.AllInstances;
import org.nakedobjects.nof.core.reflect.AbstractConsent;
import org.nakedobjects.nof.core.reflect.Allow;
import org.nakedobjects.nof.core.reflect.Veto;
import org.nakedobjects.nof.core.util.Assert;
import org.nakedobjects.nof.core.util.UnexpectedCallException;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.ObjectContent;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.UserAction;
import org.nakedobjects.nos.client.dnd.UserActionSet;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.action.AbstractUserAction;
import org.nakedobjects.nos.client.dnd.drawing.Image;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.image.ImageFactory;


public abstract class AbstractObjectContent extends AbstractContent implements ObjectContent {

    public static final class ExplorationInstances extends AbstractUserAction {

        public ExplorationInstances() {
            super("Instances", UserAction.EXPLORATION);
        }

        public Consent disabled(final View view) {
            Naked object = view.getContent().getNaked();
            return AbstractConsent.allow(object != null);
        }

        public void execute(final Workspace workspace, final View view, final Location at) {
            Naked object = view.getContent().getNaked();
            NakedObjectSpecification spec = object.getSpecification();
            NakedCollection instances = NakedObjectsContext.getObjectPersistor().findInstances(new AllInstances(spec, false));

            Content content = Toolkit.getContentFactory().createRootContent(instances);
            View cloneView = Toolkit.getViewFactory().createWindow(content);
            cloneView.setLocation(at);
            workspace.addView(cloneView);
        }
    }

    public static final class ExplorationClone extends AbstractUserAction {

        public ExplorationClone() {
            super("Clone", UserAction.EXPLORATION);
        }

        public Consent disabled(final View view) {
            NakedObject object = (NakedObject) view.getContent().getNaked();
            return AbstractConsent.allow(object != null);
        }

        public void execute(final Workspace workspace, final View view, final Location at) {
            NakedObject original = (NakedObject) view.getContent().getNaked();
            // NakedObject original = getObject();
            NakedObjectSpecification spec = original.getSpecification();

            NakedObject clone = NakedObjectsContext.getObjectLoader().createTransientInstance(spec);
            NakedObjectField[] fields = spec.getFields();
            for (int i = 0; i < fields.length; i++) {
                Naked fld = fields[i].get(original);

                if (fields[i].isObject()) {
                    ((OneToOneAssociation) fields[i]).setAssociation(clone, (NakedObject) fld);
                } else if (fields[i].isValue()) {
                    ((ValueAssociation) fields[i]).setValue(clone, (NakedValue) fld);
                } else if (fields[i].isCollection()) {

                    // clone.setValue((OneToOneAssociation) fields[i], fld.getObject());
                }
            }

            // AbstractNakedObject clone = (AbstractNakedObject) createInstance(getClass());
            // clone.copyObject(this);
            // clone.objectChanged();

            Content content = Toolkit.getContentFactory().createRootContent(clone);
            View cloneView = Toolkit.getViewFactory().createWindow(content);
            cloneView.setLocation(at);
            workspace.addView(cloneView);
            // newWorkspace.markDamaged();

        }
    }

    public static final class DebugClearResolvedOption extends AbstractUserAction {

        private DebugClearResolvedOption() {
            super("Clear resolved", UserAction.DEBUG);
        }

        public Consent disabled(final View view) {
            NakedObject object = (NakedObject) view.getContent().getNaked();
            return AbstractConsent.allow(object == null || object.getResolveState() != ResolveState.TRANSIENT
                    || object.getResolveState() == ResolveState.GHOST);
        }

        public void execute(final Workspace workspace, final View view, final Location at) {
            NakedObject object = (NakedObject) view.getContent().getNaked();
            object.changeState(ResolveState.GHOST);
        }
    }

    public abstract Consent canClear();

    public Consent canDrop(final Content sourceContent) {
        NakedObject target = (NakedObject) getObject();
        if (!(sourceContent instanceof ObjectContent) || target == null) {
            return new Veto("Can't drop " + sourceContent.getNaked().titleString() + " on to empty target");
        } else {
            NakedObject source = ((ObjectContent) sourceContent).getObject();
            return canDropOntoObject(target, source);
        }
    }

    private Consent canDropOntoObject(final NakedObject target, final NakedObject source) {
        NakedObjectAction action = dropAction(source, target);
        if (action != null) {
            Consent parameterSetValid = action.isParameterSetValid(target, new NakedObject[] { source });
            if (parameterSetValid.isAllowed()) {
                parameterSetValid = new Allow("Execute '" + action.getName() + "' with " + source.titleString());
            }
            return parameterSetValid;
        } else {
            return setFieldOfMatchingType(target, source);
        }
    }

    private Consent setFieldOfMatchingType(final NakedObject target, final NakedObject source) {
        if (target.getResolveState().isTransient() && source.getResolveState().isPersistent()) {
            return new Veto("Can't set field in persistent object with reference to non-persistent object");

        } else {
            NakedObjectField[] fields = target.getSpecification().getDynamicallyVisibleFields(target);
            for (int i = 0; i < fields.length; i++) {
                NakedObjectField fld = fields[i];
                if (fld.isObject() && source.getSpecification().isOfType(fld.getSpecification())) {
                    if (fld.get(target) == null
                            && ((OneToOneAssociation) fld).isAssociationValid(target, source).isAllowed()) {
                        return new Allow("Set field " + fld.getName());
                    }
                }
            }
            return new Veto("No empty field accepting object of type " + source.getSpecification().getSingularName()
                    + " in " + title());
        }
    }

    public abstract Consent canSet(final NakedObject dragSource);

    public abstract void clear();

    public Naked drop(final Content sourceContent) {
        if (sourceContent instanceof ObjectContent) {

            NakedObject source = (NakedObject) sourceContent.getNaked();
            Assert.assertNotNull(source);

            NakedObject target = (NakedObject) getObject();
            Assert.assertNotNull(target);

            if (canDrop(sourceContent).isAllowed()) {
                NakedObjectAction action = dropAction(source, target);

                if ((action != null) && action.isParameterSetValid(target, new NakedObject[] { source }).isAllowed()) {
                    return action.execute(target, new NakedObject[] { source });

                } else {
                    NakedObjectField[] fields = target.getSpecification().getDynamicallyVisibleFields(target);
                    for (int i = 0; i < fields.length; i++) {
                        NakedObjectField fld = fields[i];
                        if (fld.isObject() && source.getSpecification().isOfType(fld.getSpecification())) {
                            if (fld.get(target) == null
                                    && ((OneToOneAssociation) fld).isAssociationValid(target, source).isAllowed()) {
                                ((OneToOneAssociation) fld).setAssociation(target, source);
                                break;
                            }
                        }
                    }
                }
            }

        }

        return null;
    }

    private NakedObjectAction dropAction(final NakedObject source, final NakedObject target) {
        NakedObjectAction action;
        action = target.getSpecification().getObjectAction(NakedObjectAction.USER, null,
                new NakedObjectSpecification[] { source.getSpecification() });
        return action;
    }

    public abstract NakedObject getObject();

    public boolean isPersistable() {
        return getObject().persistable() == Persistable.USER_PERSISTABLE;
    }

    public void contentMenuOptions(final UserActionSet options) {
        final NakedObject object = getObject();
        OptionFactory.addObjectMenuOptions(object, options);

        if (getObject() == null) {
            OptionFactory.addCreateOptions(getSpecification(), options);
        } else {
            options.add(new ExplorationInstances());
        }

        options.add(new ExplorationClone());

        options.add(new DebugClearResolvedOption());

    }

    public void parseTextEntry(final String entryText) {
        throw new UnexpectedCallException();
    }

    public abstract void setObject(final NakedObject object);

    public String getIconName() {
        NakedObject object = getObject();
        return object == null ? null : object.getIconName();
    }

    public Image getIconPicture(final int iconHeight) {
        NakedObject nakedObject = getObject();
        if (nakedObject == null) {
            return ImageFactory.getInstance().loadIcon("empty-field", iconHeight, null);
        }
        NakedObjectSpecification specification = nakedObject.getSpecification();
        Image icon = ImageFactory.getInstance().loadIcon(specification, iconHeight, null);
        return icon;
    }

}
// Copyright (c) Naked Objects Group Ltd.
