package org.nakedobjects.nos.client.dnd.content;

import org.nakedobjects.noa.adapter.NakedValue;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.nos.client.dnd.drawing.Image;


public abstract class AbstractValueContent extends AbstractContent {

    public abstract void clear();

    public abstract void entryComplete();

    public Image getIconPicture(final int iconHeight) {
        return null;
    }

    public abstract NakedValue getObject();

    public abstract boolean isEmpty();

    public boolean isPersistable() {
        return false;
    }

    public boolean isTransient() {
        return false;
    }

    public boolean isValue() {
        return true;
    }

    public abstract void parseTextEntry(final String entryText);

    public abstract Consent isEditable();
}
// Copyright (c) Naked Objects Group Ltd.
