package org.nakedobjects.nos.client.dnd.content;

import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.NakedReference;
import org.nakedobjects.noa.adapter.NakedValue;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.noa.reflect.NakedObjectAction;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nos.client.dnd.ParameterContent;


public class ActionHelper {


    public static ActionHelper createInstance(final NakedReference target, final NakedObjectAction action) {
        int numberParameters = action.getParameterTypes().length;
        Naked[] parameters = new Naked[numberParameters];
        Naked[] defaultValues;
        Naked[][] options;
        String[] names;
        String [] descriptions;
        boolean[] optional;
        names = action.getParameterNames();
        descriptions = action.getParameterDescriptions();
        defaultValues = action.getDefaultParameterValues(target);
        options = action.getOptions(target);
        optional = action.getOptionalParameters();

        Naked[] values;
        NakedObjectSpecification[] parameterTypes;
        parameterTypes = action.getParameterTypes();
        values = new Naked[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; i++) {
            if (parameterTypes[i].getType() == NakedObjectSpecification.VALUE) {
                values[i] = NakedObjectsContext.getObjectLoader().createValueInstance(parameterTypes[i]);
            } else {
                values[i] = null;
            }
        }

        Naked[] parameterValues;
        parameterValues = new Naked[parameterTypes.length];
        for (int i = 0; i < parameterValues.length; i++) {
            parameterValues[i] = values[i];
        }

        for (int i = 0; i < numberParameters; i++) {
            if (defaultValues[i] == null) {
                parameters[i] = parameterValues[i];
            } else {
                parameters[i] = defaultValues[i];
            }
        }

        int[] maxLength = action.getParameterMaxLengths();
        int[] typicalLength = action.getParameterTypicalLengths();
        int[] noLines = action.getParameterNoLines();
        boolean[] canWrap = action.canParametersWrap();

        return new ActionHelper(target, action, names, descriptions, parameters, parameterTypes, optional, options, noLines, canWrap, maxLength,
                typicalLength);
    }

    private final NakedObjectAction action;
    private final String[] names;
    private final Naked[] parameters;
    private final NakedObjectSpecification[] types;
    private final NakedReference target;
    private final boolean[] optional;
    private final Naked[][] options;
    private final int[] noLines;
    private final int[] maxLengths;
    private final int[] typicalLength;
    private final String[] descriptions;
    private final boolean[] canWrap;

    private ActionHelper(
            final NakedReference target,
            final NakedObjectAction action,
            final String[] names,
            final String[] descriptions, 
            final Naked[] parameters,
            final NakedObjectSpecification[] types,
            final boolean[] optional,
            final Naked[][] options,
            final int noLines[],
            final boolean canWrap[],
            final int maxLengths[],
            final int typicalLength[]) {
        this.target = target;
        this.action = action;
        this.names = names;
        this.descriptions = descriptions;
        this.parameters = parameters;
        this.types = types;
        this.optional = optional;
        this.options = options;
        this.noLines = noLines;
        this.canWrap = canWrap;
        this.maxLengths = maxLengths;
        this.typicalLength = typicalLength;
    }

    public ParameterContent[] createParameters() {
        ParameterContent[] parameterContents = new ParameterContent[parameters.length];
        for (int i = 0; i < parameters.length; i++) {
            if (types[i].getType() == NakedObjectSpecification.VALUE) {
                parameterContents[i] = new ValueParameterImpl(names[i], descriptions[i], parameters[i], types[i], !optional[i],
                        (NakedValue[]) options[i],  noLines[i], canWrap[i], maxLengths[i], typicalLength[i]);
            } else {
                parameterContents[i] = new ObjectParameterImpl(names[i], descriptions[i], parameters[i], types[i], !optional[i],
                        (NakedObject[]) options[i], i, this);
            }
        }

        return parameterContents;
    }

    public Consent disabled() {
        // REVIEW this is no good as it lumps all the parameters together; I need to know which parameter is disabled! 
        return action.isParameterSetValid(target, parameters);
    }

    public String getName() {
        return action.getName();
    }

    public String getDescription() {
        return action.getDescription();
    }

    public String getHelp() {
        return action.getHelp();
    }

    public Naked getParameter(final int index) {
        return parameters[index];
    }

    public NakedReference getTarget() {
        return action.realTarget(target);
    }

    public Naked invoke() {
        return action.execute(target, parameters);
    }

    public void setParameter(final int index, final Naked parameter) {
        this.parameters[index] = parameter;
    }

    public String title() {
        return getTarget().titleString();
    }

    public String getIconName() {
        return getTarget().getIconName();
    }
}
// Copyright (c) Naked Objects Group Ltd.
