package org.nakedobjects.nos.client.dnd.content;

import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.nos.client.dnd.OneToManyFieldElement;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.action.AbstractUserAction;
import org.nakedobjects.nos.client.dnd.drawing.Location;


public class ClearOneToManyAssociationOption extends AbstractUserAction {

    public ClearOneToManyAssociationOption() {
        super("Clear association");
    }

    public Consent disabled(final View view) {
        OneToManyFieldElement content = (OneToManyFieldElement) view.getContent();
        return content.canClear();
    }

    public void execute(final Workspace frame, final View view, final Location at) {
        OneToManyFieldElement content = (OneToManyFieldElement) view.getContent();
        content.clear();
    }
}
// Copyright (c) Naked Objects Group Ltd.
