package org.nakedobjects.nos.client.dnd.content;

import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.nos.client.dnd.OneToOneField;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.action.AbstractUserAction;
import org.nakedobjects.nos.client.dnd.drawing.Location;


public class ClearOneToOneAssociationOption extends AbstractUserAction {
    public ClearOneToOneAssociationOption() {
        super("Clear association");
    }

    public Consent disabled(final View view) {
        OneToOneField content = ((OneToOneField) view.getContent());
        return content.canClear();
    }

    public void execute(final Workspace frame, final View view, final Location at) {
        OneToOneField content = ((OneToOneField) view.getContent());
        content.clear();
        view.getParent().invalidateContent();
    }
}
// Copyright (c) Naked Objects Group Ltd.
