package org.nakedobjects.nos.client.dnd.content;

import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedCollection;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.reflect.Veto;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nof.core.util.NotImplementedException;
import org.nakedobjects.nos.client.dnd.ActionContent;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.ParameterContent;


public class CollectionActionContent extends AbstractCollectionContent implements ActionContent {
    private final ActionHelper invocation;
    private final ParameterContent[] parameters;

    public CollectionActionContent(final ActionHelper invocation) {
        this.invocation = invocation;
        parameters = invocation.createParameters();
    }

    public void debugDetails(final DebugString debug) {
        debug.appendln("action", getActionName());
        debug.appendln("target", getNaked());
        String parameterSet = "";
        for (int i = 0; i < parameters.length; i++) {
            parameterSet += parameters[i];
        }
        debug.appendln("parameters", parameterSet);
    }

    public Consent canDrop(final Content sourceContent) {
        return Veto.DEFAULT;
    }

    public Consent disabled() {
        return invocation.disabled();
    }

    public Naked drop(final Content sourceContent) {
        throw new NotImplementedException();
    }

    public NakedObject[] elements() {
        throw new NotImplementedException();
    }

    public Naked execute() {
        return invocation.invoke();
    }

    public String getActionName() {
        return invocation.getName();
    }

    public NakedCollection getCollection() {
        return (NakedCollection) invocation.getTarget();
    }

    public String getDescription() {
        return invocation.getDescription();
    }

    public String getHelp() {
        return invocation.getHelp();
    }

    public String getIconName() {
        return getNaked().getIconName();
    }

    public String getId() {
        return invocation.getName();
    }

    public Naked getNaked() {
        return invocation.getTarget();
    }

    public int getNoParameters() {
        return parameters.length;
    }

    public ParameterContent getParameterContent(final int index) {
        return parameters[index];
    }

    public Naked getParameterObject(final int index) {
        return invocation.getParameter(index);
    }

    public NakedObjectSpecification getSpecification() {
        return getNaked().getSpecification();
    }

    public boolean isTransient() {
        return true;
    }

    public String title() {
        return getNaked().titleString();
    }

    public String windowTitle() {
        return getActionName();
    }
}
// Copyright (c) Naked Objects Group Ltd.
