package org.nakedobjects.nos.client.dnd.content;

import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.reflect.Veto;
import org.nakedobjects.nof.core.util.DebugString;


public class CollectionElement extends AbstractObjectContent {
    private final NakedObject object;

    public CollectionElement(final NakedObject object) {
        this.object = object;
    }

    public boolean isObject() {
        return true;
    }

    public boolean isOptionEnabled() {
        return false;
    }

    public Consent canClear() {
        return Veto.DEFAULT;
    }

    public Consent canSet(final NakedObject dragSource) {
        return Veto.DEFAULT;
    }

    public void clear() {
        throw new NakedObjectRuntimeException("Invalid call");
    }

    public void debugDetails(final DebugString debug) {
        debug.appendln("element", object);
    }

    public String getId() {
        return "";
    }

    public String getDescription() {
        return  getSpecification().getSingularName() + ": " + getObject().titleString() + " " + getSpecification().getDescription();
    }

    public String getHelp() {
        return "";
    }

    public NakedObject getObject() {
        return object;
    }

    public Naked getNaked() {
        return object;
    }

    public NakedObjectSpecification getSpecification() {
        return object.getSpecification();
    }

    public boolean isTransient() {
        return object.getResolveState().isTransient();
    }

    public void setObject(final NakedObject object) {
        throw new NakedObjectRuntimeException("Invalid call");
    }

    public String title() {
        return object.titleString();
    }

    public String windowTitle() {
        return getSpecification().getShortName();
    }

    public String toString() {
        return "" + object;
    }

    public Naked[] getOptions() {
        return null;
    }
}
// Copyright (c) Naked Objects Group Ltd.
