package org.nakedobjects.nos.client.dnd.content;

import org.nakedobjects.noa.adapter.NakedCollection;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.NakedReference;
import org.nakedobjects.noa.reflect.NakedObjectAction;
import org.nakedobjects.noa.spec.Features;
import org.nakedobjects.nof.core.util.Assert;
import org.nakedobjects.nof.core.util.UnknownTypeException;
import org.nakedobjects.nos.client.dnd.BackgroundTask;
import org.nakedobjects.nos.client.dnd.BackgroundThread;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.drawing.Location;


/**
 * Options for an underlying object determined dynamically by looking for methods starting with action, veto
 * and option for specifying the action, vetoing the option and giving the option an name respectively.
 */
public class DialoggedObjectOption extends AbstractObjectOption {
    public static DialoggedObjectOption createOption(final NakedObjectAction action, final NakedReference object) {
        int paramCount = action.getParameterCount();
        Assert.assertTrue("Only for actions taking one or more params", paramCount > 0);
        if (!action.isVisible() || !action.isVisible(object)) {
            return null;
        }

        DialoggedObjectOption option = new DialoggedObjectOption(action, object);
        return option;
    }

    private DialoggedObjectOption(final NakedObjectAction action, final NakedReference target) {
        super(action, target, action.getName() + "...");
    }

    public void execute(final Workspace workspace, final View view, final Location at) {
        BackgroundThread.run(view, new BackgroundTask() {
            public void execute() {
                ActionHelper helper = ActionHelper.createInstance(target, action);
                Content content;
                if (target instanceof NakedObject || target == null && Features.isService(action.getOnType())) {
                    content = new ObjectActionContent(helper);
                } else if (target instanceof NakedCollection) {
                    content = new CollectionActionContent(helper);
                } else {
                    throw new UnknownTypeException(target);
                }
                View dialog = Toolkit.getViewFactory().createDialog(content);
                Location loc = view.getAbsoluteLocation();
                dialog.setLocation(loc);
                workspace.addView(dialog);
            }

            public String getDescription() {
                return "Preparing action " + getName() + " on  " + view.getContent().getNaked();
            }

            public String getName() {
                return "Preparing action " + action.getName();
            }
        });
    }
}
// Copyright (c) Naked Objects Group Ltd.
