package org.nakedobjects.nos.client.dnd.content;

import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.nos.client.dnd.Comparator;


public class FieldComparator implements Comparator {
    private final NakedObjectField field;
    private String title;

    public FieldComparator(final NakedObjectField field) {
        this.field = field;
    }

    public void init(final NakedObject element) {
        Naked refTo = field.get(element);
        title = refTo == null ? null : refTo.titleString();
        title = title == null ? "" : title;
    }

    public int compare(final NakedObject sortedElement) {
        Naked refTo = field.get(sortedElement);
        String sortedTitle = refTo == null ? null : refTo.titleString();
        sortedTitle = sortedTitle == null ? "" : sortedTitle;
        int compareTo = sortedTitle.compareTo(title);
        return compareTo;
    }

    public NakedObjectField getField() {
        return field;
    }
}
// Copyright (c) Naked Objects Group Ltd.
