package org.nakedobjects.nos.client.dnd.content;

import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedCollection;
import org.nakedobjects.noa.adapter.NakedReference;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.noa.reflect.NakedObjectAction;
import org.nakedobjects.nof.core.util.Assert;
import org.nakedobjects.nos.client.dnd.BackgroundTask;
import org.nakedobjects.nos.client.dnd.BackgroundThread;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.drawing.Location;


/**
 * Options for an underlying object determined dynamically by looking for methods starting with action, veto
 * and option for specifying the action, vetoing the option and giving the option an name respectively.
 */
public class ImmediateObjectOption extends AbstractObjectOption {

    public static ImmediateObjectOption createOption(final NakedObjectAction action, final NakedReference object) {
        Assert.assertTrue("Only suitable for 0 param methods", action.getParameterTypes().length == 0);
        if (!action.isVisible() || !action.isVisible(object)) {
            return null;
        }
        ImmediateObjectOption option = new ImmediateObjectOption(action, object);
        return option;
    }

    public static ImmediateObjectOption createServiceOption(final NakedObjectAction action, final NakedReference object) {
        Assert.assertTrue("Only suitable for 1 param methods", action.getParameterTypes().length == 1);
        if (!action.isVisible() || !action.isVisible(object)) {
            return null;
        }
        ImmediateObjectOption option = new ImmediateObjectOption(action, object);

        return option;
    }

    private ImmediateObjectOption(final NakedObjectAction action, final NakedReference target) {
        super(action, target, action.getName());
    }

    protected Consent checkValid() {
        return action.isParameterSetValid(target, null);
    }
    
    // TODO this method is very similar to ActionDialogSpecification.execute()
    public void execute(final Workspace workspace, final View view, final Location at) {
        BackgroundThread.newRun(view, new BackgroundTask() {
            public void execute() {
                Naked result;
                result = action.execute(target, null);
                if (result != null) {
                    if (result instanceof NakedCollection) {
                        NakedCollection collection = ((NakedCollection) result);
                        if (collection.size() == 1) {
                            result = collection.firstElement();
                        }
                    }
                    view.objectActionResult(result, at);
                }
                view.getViewManager().disposeUnneededViews();
                view.getFeedbackManager().showMessagesAndWarnings();
            }

            public String getDescription() {
                return "Running action " + getName() + " on  " + view.getContent().getNaked();
            }

            public String getName() {
                return "NakedObjectAction " + action.getName();
            }
        });
    }
}
// Copyright (c) Naked Objects Group Ltd.
