package org.nakedobjects.nos.client.dnd.content;

import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.reflect.Veto;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nos.client.dnd.ActionContent;
import org.nakedobjects.nos.client.dnd.ParameterContent;


/**
 * Links an action on an object to a view.
 */
public class ObjectActionContent extends AbstractObjectContent implements ActionContent {
    private final ActionHelper actionHelper;
    private final ParameterContent[] parameters;

    public ObjectActionContent(final ActionHelper invocation) {
        this.actionHelper = invocation;
        parameters = invocation.createParameters();
    }

    public Consent canClear() {
        return Veto.DEFAULT;
    }

    public Consent canSet(final NakedObject dragSource) {
        return Veto.DEFAULT;
    }

    public void clear() {
        throw new NakedObjectRuntimeException("Invalid call");
    }

    public void debugDetails(final DebugString debug) {
        debug.appendln("action", getActionName());
        debug.appendln("target", getNaked());
        String parameterSet = "";
        for (int i = 0; i < parameters.length; i++) {
            parameterSet += parameters[i];
        }
        debug.appendln("parameters", parameterSet);
    }

    public Consent disabled() {
        return actionHelper.disabled();
    }

    public Naked execute() {
        return actionHelper.invoke();
    }

    public String getActionName() {
        return actionHelper.getName();
    }

    public String getIconName() {
        return actionHelper.getIconName();
    }
   
    public Naked getNaked() {
        return actionHelper.getTarget();
    }

    public int getNoParameters() {
        return parameters.length;
    }

    public NakedObject getObject() {
        return (NakedObject) actionHelper.getTarget();
    }

    public ParameterContent getParameterContent(final int index) {
        return parameters[index];
    }

    public Naked getParameterObject(final int index) {
        return actionHelper.getParameter(index);
    }

    public NakedObjectSpecification getSpecification() {
        return getObject().getSpecification();
    }

    /**
     * Can't persist actions
     */
    public boolean isPersistable() {
        return false;
    }

    public boolean isObject() {
        return true;
    }

    public boolean isTransient() {
        return true;
    }

    public void setObject(final NakedObject object) {
        throw new NakedObjectRuntimeException("Invalid call");
    }

    public String title() {
        return actionHelper.title();
    }

    public String windowTitle() {
        return getActionName();
    }

    public String getId() {
        return actionHelper.getName();
    }

    public String getDescription() {
        return actionHelper.getDescription();
    }

    public String getHelp() {
        return actionHelper.getHelp();
    }

    public Naked[] getOptions() {
        return null;
    }

    public boolean isOptionEnabled() {
        return false;
    }

}
// Copyright (c) Naked Objects Group Ltd.
