package org.nakedobjects.nos.client.dnd.content;

import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.reflect.NakedObjectField;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.util.DebugString;


final class ObjectField {
    private final NakedObjectField field;
    private final NakedObject parent;

    ObjectField(NakedObject parent, NakedObjectField field) {
        this.parent = parent;
        this.field = field;
    }

    public void debugDetails(final DebugString debug) {
        debug.appendln("field", getFieldReflector());
        debug.appendln("name", getName());
        debug.appendln("specification", getSpecification());
        debug.appendln("parent", parent);
    }

    public String getDescription() {
        return field.getDescription();
    }

    public String getHelp() {
        return field.getHelp();
    }

    public NakedObjectField getFieldReflector() {
        return field;
    }

    public final String getName() {
        return field.getName();
    }

    public NakedObject getParent() {
        return parent;
    }

    public NakedObjectSpecification getSpecification() {
        return field.getSpecification();
    }
}
// Copyright (c) Naked Objects Group Ltd.
